<?php 
    // Including db_connect to prevent errors, but data is static below
    include 'db_connect.php'; 
    include 'header.php'; 
?>

<section class="page-hero" style="height: 40vh; background: linear-gradient(rgba(102, 0, 0, 0.6), rgba(102, 0, 0, 0.6)), url('images/podium-microphone.jpg') no-repeat center center/cover;">
    <div class="container">
        <h1>Ceremonial Speeches</h1>
        <p>Addresses delivered at Ceremonial Sittings of the Civil Appellate High Court.</p>
    </div>
</section>

<section class="content-section reveal" style="padding: 80px 8%; background-color: #fff;">
    
    <div class="speech-container" style="max-width: 900px; margin: 0 auto; background: white; padding: 50px; border-radius: 8px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); border-top: 4px solid var(--primary-color);">
        
        <div class="speech-item" style="margin-bottom: 60px;">
            <div class="speech-header" style="text-align: center; margin-bottom: 30px;">
                <p class="fancy-text" style="color: var(--gold-accent); font-style: italic; font-family: 'Playfair Display', serif; font-size: 1.1rem;">January 20, 2026</p>
                <h2 class="speech-title" style="color: var(--primary-color); font-size: 2rem; margin-top: 5px;">Welcome Address for New High Court Judges</h2>
                <div class="center-divider" style="width: 50px; height: 3px; background: var(--gold-accent); margin: 15px auto;"></div>
            </div>
            
            <div class="speech-body" style="font-size: 1.05rem; line-height: 1.8; color: #444; text-align: justify;">
                <p>
                    "It is with a sense of great responsibility that we welcome the newly appointed Justices to the Civil Appellate High Court. This court stands as a bastion for the protection of civil rights, from land ownership to contractual obligations..."
                </p>
                
                <blockquote style="border-left: 4px solid var(--gold-accent); padding: 20px; background: #f9f9f9; color: var(--primary-color); font-family: 'Playfair Display', serif; font-size: 1.2rem; margin: 30px 0;">
                    "The efficiency of the appellate process is the bedrock of commercial confidence and social stability."
                </blockquote>
                
                <p>
                    The President of the Bar Association emphasized the need for expediting land partition appeals to serve the public interest better.
                </p>
                
                <div style="text-align: center; margin-top: 25px;">
                    <a href="#" class="btn-download" style="background: #333; color: white; padding: 12px 25px; text-decoration: none; border-radius: 4px; font-size: 0.9rem; display: inline-block;">
                        <i class="fas fa-file-pdf" style="margin-right: 8px;"></i> Read Full Speech
                    </a>
                </div>
            </div>
        </div>

        <hr style="border: 0; border-top: 1px dashed #ccc; margin-bottom: 60px;">

        <div class="speech-item">
            <div class="speech-header" style="text-align: center; margin-bottom: 30px;">
                <p class="fancy-text" style="color: var(--gold-accent); font-style: italic; font-family: 'Playfair Display', serif; font-size: 1.1rem;">December 15, 2025</p>
                <h2 class="speech-title" style="color: var(--primary-color); font-size: 2rem; margin-top: 5px;">Farewell Ceremony for Hon. Justice K. Perera</h2>
                <div class="center-divider" style="width: 50px; height: 3px; background: var(--gold-accent); margin: 15px auto;"></div>
            </div>
            
            <div class="speech-body" style="font-size: 1.05rem; line-height: 1.8; color: #444; text-align: justify;">
                <p>
                    The Bench and Bar gathered today to bid farewell to His Lordship, who served the Civil Appellate High Court for over a decade. His contributions to the jurisprudence of Partition Law will be cited for generations to come.
                </p>
                <p>
                    During his tenure, His Lordship delivered over 500 judgments related to Civil Appellate matters, significantly reducing the case backlog in the Western Province.
                </p>
                
                <div style="text-align: center; margin-top: 25px;">
                    <a href="#" class="btn-download" style="background: #333; color: white; padding: 12px 25px; text-decoration: none; border-radius: 4px; font-size: 0.9rem; display: inline-block;">
                        <i class="fas fa-file-pdf" style="margin-right: 8px;"></i> Read Full Speech
                    </a>
                </div>
            </div>
        </div>

    </div>

</section>

<script>
    // Simple Reveal Animation
    window.addEventListener('scroll', function() {
        var reveals = document.querySelectorAll('.reveal');
        for(var i = 0; i < reveals.length; i++){
            var windowheight = window.innerHeight;
            var revealtop = reveals[i].getBoundingClientRect().top;
            var revealpoint = 150;
            if(revealtop < windowheight - revealpoint){
                reveals[i].classList.add('active');
            }
        }
    });
</script>

<?php include 'footer.php'; ?>